function show360stereo(vr_jpg_path){
	//Ăꏊ\#########################
	var lookAtVector = new THREE.Vector3(0,0, -1);

  var ua = navigator.userAgent;
    if (ua.indexOf('iPad') > 0 || ua.indexOf('Tablet') > 0 || ua.indexOf('Kindle') > 0 || ua.indexOf('Touch') > 0 || ua.indexOf('Nexus 7') > 0 || ua.indexOf('Nexus 10') > 0) {
        var sp = false;
    }else{
        var sp = true;
    }
/*
    if (ua.indexOf('iPhone') > 0 || ua.indexOf('iPod') > 0 || ua.indexOf('Android') > 0) {
        var sp = true;
    }else if(ua.indexOf('iPad') > 0 || ua.indexOf('Android') > 0){
        var sp = true;
    }
*/

  var width = window.innerWidth,
      height = window.innerHeight;

  //scene

  var scene = new THREE.Scene();

  //mesh

  var geometry = new THREE.SphereGeometry( 5, 60, 40 ,4.71);
    geometry.scale( - 1, 1, 1 );

    var material = new THREE.MeshBasicMaterial( {
       map: THREE.ImageUtils.loadTexture(vr_jpg_path)
    } );

    sphere = new THREE.Mesh( geometry, material );

    scene.add( sphere );

  //camera

  if(sp){
	var camera = new THREE.PerspectiveCamera(75, width / height, 1, 1000);
  }else{
	var camera = new THREE.PerspectiveCamera(70, width / height, 1, 1000);
  }
  camera.position.set(0,0,0.1);
  camera.lookAt(sphere.position);

  //helper
  //var axis = new THREE.AxisHelper(1000);
  //axis.position.set(0,0,0);
  //scene.add(axis);

  //render

  var renderer = new THREE.WebGLRenderer();
  renderer.setSize(width,height);
  renderer.setClearColor({color: 0x000000});
  document.getElementById('stage').appendChild(renderer.domElement);
  renderer.render(scene,camera);

	//##########################
	// VR\֕ϊ
	effect = new THREE.StereoEffect(renderer);
		//̃p[^
		effect.separation = 0;
		effect.focalLength = 5;	
	//##########################

  //control

  if(sp){
    var gcontrols = new THREE.DeviceOrientationControls(camera, renderer.domElement);
  }else{
    var controls = new THREE.DeviceOrientationControls(camera, renderer.domElement);
//    var controls = new THREE.OrbitControls(camera, renderer.domElement);
  }
  
    render();
	//-----------------------------------------------------------
        camera.aspect = window.innerWidth / window.innerHeight;
        //camera.aspect = window.Width / window.Height;
        camera.updateProjectionMatrix();
		//##########################
        //renderer.setSize( window.innerWidth, window.innerHeight );
        effect.setSize( window.innerWidth, window.innerHeight);
        //effect.setSize( window.Width, window.Height );
      	//##########################
	//-----------------------------------------------------------

  function render(){
    requestAnimationFrame(render);
    window.addEventListener( 'resize', onWindowResize, false );
    renderer.render(scene,camera);

    if(sp){
      gcontrols.connect();
      gcontrols.update();

		//##########################
		effect.render(scene, camera);
		//##########################

    }else{
//      sphere.rotation.y += 0.01 * Math.PI/180;
      controls.connect();
      controls.update();
      
		//##########################
		effect.render(scene, camera);
		//##########################      
    }
    
    //Ăꏊ\######################
	lookAtVector.applyQuaternion(camera.quaternion);
	//alert(lookAtVector);
    //Ăꏊ\######################
  }
  function onWindowResize() {
        camera.aspect = window.innerWidth / window.innerHeight;
        //camera.aspect = window.Width / window.Height;
        camera.updateProjectionMatrix();
		//##########################
        //renderer.setSize( window.innerWidth, window.innerHeight );
		if(sp){
	        effect.setSize( window.innerWidth, window.innerHeight+1 );
		}else{
	        effect.setSize( window.innerWidth, window.innerHeight);
		}
        //effect.setSize( window.Width, window.Height );
      	//##########################

   }

}